function main(self)
	local physicsFlags = PhysicsFlags

    if self.State == 0 then
		self:SetImage("CUSTOM_ICESHIELD")
		self:SetAnimation("CUSTOM_CYCLE72")
		self.BumpFlags.EnemyBullet = true
		self.AttackFlags.Player = true
		self.HitFlags.Player = true
		self.HitFlags.ThrownObject = true
		self.HitFlags.PistolBullet = true
		self.HitFlags.EnvBullet = true
		self.HitFlags.MagicBullet = true
		self.AttackRect = {-12,-12,12,12}
		self.MoveRect = {-12,-12,12,12}
		self.HitRect = {-12,-12,12,12}
		self.Flags.AlwaysActive = true
		self.PhysicsType = PhysicsTypes.Fly

		local detector = GetObject(3206)
		local difficulty = detector.Difficulty
		self.Damage = difficulty == 2 and 15 or difficulty == 1 and 5 or 10

		if self.SpeedX == 0 and self.SpeedY == 0 then
			self.SpeedX, self.SpeedY = -1, -1
		end
		self.initialSpeedX, self.initialSpeedY = self.SpeedX, self.SpeedY

        self.State = 5
		return
	end

	self:AnimationStep()

	if self.State == 5 then

		if self.Y > self.YMax or self.Y < self.YMin then
			self.SpeedY = -self.SpeedY
		end
		if self.X > self.XMax or self.X < self.XMin then
			self.SpeedX = -self.SpeedX
		end

		local move = self:Physics(self.X + self.SpeedX, self.Y + self.SpeedY)

		if AND(move, physicsFlags.WallHit) ~= 0 then
			self.SpeedX = -self.SpeedX
		end

		if move > physicsFlags.ElevatorLand then
			self.SpeedY = -self.SpeedY
		end

		self.Flags.OnElevator = false
		self.Flags.OnDeathTile = false

		return
	end

	if self.State == 28 then
		self.SpeedX, self.SpeedY = 0, 0
	end

	if self.State == 2000 then
		self.SpeedX, self.SpeedY = self.initialSpeedX, self.initialSpeedY
		self.State = 1
	end
end

function attack(self)
	if GetClaw().HitFlags.EnemyBullet == true then
		CreateObject {x=self.X, y=self.Y, z=6000, name="IceBallExplosion"}
		PlaySound("CLAW_ICESWORD")
		self:Destroy()
	end
end

function hit(self)
	CreateObject {x=self.X, y=self.Y, z=6000, name="IceBallExplosion"}
	PlaySound("CLAW_ICESWORD")
	self:Destroy()
end